/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.auiml.databeans.sfp.data;

import com.ibm.rsct.util.CtArray;
import com.ibm.rsct.util.CtDataType;
import com.ibm.rsct.util.CtString;
import com.ibm.rsct.util.CtStructuredData;
import com.ibm.rsct.util.CtUint32;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public abstract class StructuredData
implements Serializable {
    protected CtStructuredData structuredData = null;
    protected CtDataType[] data = new CtDataType[0];
    public static final SimpleDateFormat TS_FORMATTER = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");

    public StructuredData(CtStructuredData ctStructuredData) {
        this.structuredData = ctStructuredData;
        if (ctStructuredData != null) {
            this.data = ctStructuredData.getData();
        }
    }

    protected String getStringMember(int n) {
        try {
            return ((CtString)this.getMember(n)).getData();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return "";
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    protected boolean getBooleanMember(int n) {
        String string = this.getStringMember(n);
        return "Yes".equalsIgnoreCase(string);
    }

    protected int getIntegerMember(int n) {
        try {
            return ((CtUint32)this.getMember(n)).getJniData();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return -1;
        }
        catch (NullPointerException nullPointerException) {
            return -1;
        }
    }

    protected String[] getStringArrayMember(int n) {
        CtDataType[] ctDataTypeArray = this.getArrayMember(n);
        int n2 = ctDataTypeArray.length;
        String[] stringArray = new String[n2];
        int n3 = 0;
        while (n3 < n2) {
            stringArray[n3] = ((CtString)ctDataTypeArray[n3]).getData();
            ++n3;
        }
        return stringArray;
    }

    protected Date getTimestampMember(int n) {
        String string = this.getStringMember(n);
        try {
            return TS_FORMATTER.parse(string);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    private CtDataType[] getArrayMember(int n) {
        try {
            return ((CtArray)this.getMember(n)).getData();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return new CtDataType[0];
        }
        catch (NullPointerException nullPointerException) {
            return new CtDataType[0];
        }
    }

    private CtDataType getMember(int n) {
        return this.data[n];
    }

    protected CtStructuredData getStructuredData() {
        return this.structuredData;
    }
}

